// JBK 32 Server - Long file names for 16-bit appilcations through DDE
//
// Version 1.0 - Freeware. Please modify as needed.
//
// (c) JBK Data 1997
//     CSID 100776,1403
//     e-mail Jens_B_Kristensen@compuserve.com
//
unit ServerU;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DdeMan, StdCtrls,jbkuti32;
  const
     cm_about=999;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    DdeServerOpenLongname: TDdeServerItem;
    DdeServerConv1: TDdeServerConv;
    Label1: TLabel;
    DdeServerShortname: TDdeServerItem;
    DdeServerSaveLongname: TDdeServerItem;
    SaveDialog1: TSaveDialog;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    DdeServerLongname: TDdeServerItem;
    procedure DdeServerOpenLongnamePokeData(Sender: TObject);
    procedure DdeServerSaveLongnamePokeData(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
  protected
     procedure wmsyscommand(var msg:Tmsg; var handled:boolean);
       
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses about;

{$R *.DFM}

procedure TForm1.DdeServerOpenLongnamePokeData(Sender: TObject);
begin
   with opendialog1 do
   begin
      filename:=ddeserveropenlongname.text;
      initialdir:=extractfiledir(filename);
      if opendialog1.execute then
      begin
         ddeserveropenlongname.text:=filename;
         ddeserversavelongname.text:=filename;
         ddeserverlongname.text:=filename;
         ddeservershortname.text:=getshortfilename(filename);
      end;
   end;
end;

procedure TForm1.DdeServerSaveLongnamePokeData(Sender: TObject);
var f:file;sr:Tsearchrec;svar:integer;
    ext:Tfilename;
begin
   with savedialog1 do
   begin
      svar:=id_yes;
      filename:=ddeserversavelongname.text;
      initialdir:=extractfiledir(filename);

      if savedialog1.execute then
      begin
         //I have had to add the following six lines - actually I thought
         //setting the 'defaultext' property and the 'ofOverwritePrompt'
         //took care of this automatically (?)
         if extractfileext(filename)='' then  //user typed no extension (they never do)
            filename:=filename+'.'+defaultext;//room for improvement. Ought to pick the selected filetype.
         if findfirst(filename,faanyfile,sr)=0 then
         svar:=application.messagebox(pchar(filename +#13+'This file already exists'+#13
            +#13+'Overwrite?'),'LFN Save as...',mb_yesno or mb_iconexclamation);
         findclose(sr);

         if svar=id_yes then
         begin
            assignfile(f,filename);
            rewrite(f);
            closefile(f);
            // Now update filenames.
            ddeserversavelongname.text:=filename;
            ddeserveropenlongname.text:=filename;
            ddeserverlongname.text:=filename;
            ddeservershortname.text:=getshortfilename(filename);
         end;
      end;
   end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    DDEserverconv1.free;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
//Only allow closing if the client application's DDE form has been closed
var h:hwnd;
begin
    canclose:=true;
    h:=findwindow(nil,'Filename DDE Client');
    if h<>0 then
    begin
       //Get a handle to client OWL app's main window and close it.
       //Probably needs a change for VCL applications.
       h:=findwindow('LFNWindow',nil);
       canclose:=false;
       postmessage(h,wm_close,0,0);
       //Now the client app. is closing. The client app. then sends a
       //wm_close message to the server(!)
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var exepath:array[0..255]of char;
    h:thandle;                                
begin
   getmodulefilename(hinstance,exepath,255);
   opendialog1.initialdir:=extractfiledir(exepath);
   savedialog1.initialdir:=extractfilepath(exepath);
   //Add About... command to system menu
   h:=getsystemmenu(application.handle,false);
   appendmenu(h,mf_bycommand or mft_string,cm_about,'About...');
   Application.onmessage:=wmsyscommand;
   //The following line hides the 32-bit server taskbar button!
   //showwindow(application.handle,sw_hide);
end;

procedure Tform1.wmsyscommand(var msg:Tmsg; var handled:boolean);
//Shows About box
begin
   if (msg.message=wm_syscommand)and(loword(msg.wparam)=cm_about) then
   aboutbox.showmodal;
end;

end.
